﻿//////////////////////////////////////////////
// AtmosphereEffectInfo.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkGraphics
{
	class Camera ;
	class Texture ;
}

/// Includes ---------------------------------

// nkAstraeus
#include "../../ShaderLibs/ShadowMapping/Data/ShadowMapParameters.h"

// nkMaths
#include <NilkinsMaths/Algebra/Vector.h>

/// Class ------------------------------------

namespace nkAstraeus
{
	struct AtmosphereEffectInfo
	{
		// Input textures
		nkGraphics::Texture* _sourceColorTexture = nullptr ;
		nkGraphics::Texture* _sourceDepthTexture = nullptr ;

		// Shadow texture to sample and its source camera, within the visibility function
		nkGraphics::Texture* _visibilityShadowTexture = nullptr ;
		nkGraphics::Camera* _visibilityShadowCamera = nullptr ;

		// Sun position in the unit sphere
		nkMaths::Vector _sunPosition = nkMaths::Vector(0, 1, 0) ;

		// Planet albedo, giving the global surrounding light
		nkMaths::Vector _planetAlbedo = nkMaths::Vector(0.1f, 0.1f, 0.1f) ;

		// Rayleigh information, model of the air molecule composition influence
		nkMaths::Vector _rayleighScattering = nkMaths::Vector(5.802f, 13.558f, 33.1f) ;
		nkMaths::Vector _rayleighExtinction = nkMaths::Vector(5.802f, 13.558f, 33.1f) ;
		nkMaths::Vector _rayleighAbsorb = nkMaths::Vector(0.f, 0.f, 0.f) ;

		// Mie information, model of the air fine particles influence
		nkMaths::Vector _mieScattering = nkMaths::Vector(3.996f, 3.996f, 3.996f) ;
		nkMaths::Vector _mieExtinction = nkMaths::Vector(3.996f + 4.4f, 3.996f + 4.4f, 3.996f + 4.4f) ;
		nkMaths::Vector _mieAbsorb = nkMaths::Vector(4.4f, 4.4f, 4.4f) ;

		// Ozone information
		nkMaths::Vector _ozoneScattering = nkMaths::Vector(0.f, 0.f, 0.f) ;
		nkMaths::Vector _ozoneExtinction = nkMaths::Vector(0.650f, 1.881f, 0.085f) ;
		nkMaths::Vector _ozoneAbsorb = nkMaths::Vector(0.650f, 1.881f, 0.085f) ;

		// Mie G parameter, can be seen as how saturated in particles the atmosphere is
		float _mieG = 0.8f ;

		// Height densities factors
		float _rayleighHeightDensityFactor = 1.f ;
		float _mieHeightDensityFactor = 1.f ;
		float _ozoneHeightDensityFactor = 1.f ;
		float _distanceFactor = 1.f ;

		// Sun information
		float _sunIlluminanceFactor = 5.f ;
		float _sunAngularRadius = 0.545f ;

		// Sampling information
		unsigned int _sunLutSampleCount = 40 ;
		unsigned int _multiScatteringLutSphereSampleCount = 8 ;
		unsigned int _multiScatteringLutMarchSampleCount = 20 ;
		unsigned int _raymarchSampleCount = 32 ;

		// Lut information
		unsigned int _sunTransmittanceLutWidth = 256 ;
		unsigned int _sunTransmittanceLutHeight = 64 ;
		unsigned int _multiScatteringLutWidth = 64 ;
		unsigned int _multiScatteringLutHeight = 64 ;
		
		// Visibility function sampling parameters
		ShadowMapParameters _visibilityShadowParameters ;

		// Flags
		bool _useHalfFloatForLuts = false ;
		bool _onlyScatterOnObjects = false ;
		bool _displaySun = true ;
	} ;
}